/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.noding;

import com.databricks.internal.jts.algorithm.LineIntersector;
import com.databricks.internal.jts.algorithm.RobustLineIntersector;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.TopologyException;
import com.databricks.internal.jts.io.WKTWriter;
import com.databricks.internal.jts.noding.MCIndexNoder;
import com.databricks.internal.jts.noding.NodingIntersectionFinder;
import java.util.Collection;
import java.util.List;

public class FastNodingValidator {
    private LineIntersector li = new RobustLineIntersector();
    private Collection segStrings;
    private boolean findAllIntersections = false;
    private NodingIntersectionFinder segInt = null;
    private boolean isValid = true;

    public static List computeIntersections(Collection segStrings) {
        FastNodingValidator nv = new FastNodingValidator(segStrings);
        nv.setFindAllIntersections(true);
        nv.isValid();
        return nv.getIntersections();
    }

    public FastNodingValidator(Collection segStrings) {
        this.segStrings = segStrings;
    }

    public void setFindAllIntersections(boolean findAllIntersections) {
        this.findAllIntersections = findAllIntersections;
    }

    public List getIntersections() {
        return this.segInt.getIntersections();
    }

    public boolean isValid() {
        this.execute();
        return this.isValid;
    }

    public String getErrorMessage() {
        if (this.isValid) {
            return "no intersections found";
        }
        Coordinate[] intSegs = this.segInt.getIntersectionSegments();
        return "found non-noded intersection between " + WKTWriter.toLineString(intSegs[0], intSegs[1]) + " and " + WKTWriter.toLineString(intSegs[2], intSegs[3]);
    }

    public void checkValid() {
        this.execute();
        if (!this.isValid) {
            throw new TopologyException(this.getErrorMessage(), this.segInt.getIntersection());
        }
    }

    private void execute() {
        if (this.segInt != null) {
            return;
        }
        this.checkInteriorIntersections();
    }

    private void checkInteriorIntersections() {
        this.isValid = true;
        this.segInt = new NodingIntersectionFinder(this.li);
        this.segInt.setFindAllIntersections(this.findAllIntersections);
        MCIndexNoder noder = new MCIndexNoder();
        noder.setSegmentIntersector(this.segInt);
        noder.computeNodes(this.segStrings);
        if (this.segInt.hasIntersection()) {
            this.isValid = false;
            return;
        }
    }
}

