/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.buffer;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateList;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LineString;
import java.util.Collections;
import java.util.List;

class OffsetCurveSection
implements Comparable<OffsetCurveSection> {
    private Coordinate[] sectionPts;
    private double location;
    private double locLast;

    public static Geometry toGeometry(List<OffsetCurveSection> sections, GeometryFactory geomFactory) {
        if (sections.size() == 0) {
            return geomFactory.createLineString();
        }
        if (sections.size() == 1) {
            return geomFactory.createLineString(sections.get(0).getCoordinates());
        }
        Collections.sort(sections);
        LineString[] lines = new LineString[sections.size()];
        for (int i = 0; i < sections.size(); ++i) {
            lines[i] = geomFactory.createLineString(sections.get(i).getCoordinates());
        }
        return geomFactory.createMultiLineString(lines);
    }

    public static Geometry toLine(List<OffsetCurveSection> sections, GeometryFactory geomFactory) {
        if (sections.size() == 0) {
            return geomFactory.createLineString();
        }
        if (sections.size() == 1) {
            return geomFactory.createLineString(sections.get(0).getCoordinates());
        }
        Collections.sort(sections);
        CoordinateList pts = new CoordinateList();
        boolean removeStartPt = false;
        for (int i = 0; i < sections.size(); ++i) {
            OffsetCurveSection section = sections.get(i);
            boolean removeEndPt = false;
            if (i < sections.size() - 1) {
                double nextStartLoc = sections.get((int)(i + 1)).location;
                removeEndPt = section.isEndInSameSegment(nextStartLoc);
            }
            Coordinate[] sectionPts = section.getCoordinates();
            for (int j = 0; j < sectionPts.length; ++j) {
                if (removeStartPt && j == 0 || removeEndPt && j == sectionPts.length - 1) continue;
                pts.add(sectionPts[j], false);
            }
            removeStartPt = removeEndPt;
        }
        return geomFactory.createLineString(pts.toCoordinateArray());
    }

    public static OffsetCurveSection create(Coordinate[] srcPts, int start, int end, double loc, double locLast) {
        int len = end - start + 1;
        if (end <= start) {
            len = srcPts.length - start + end;
        }
        Coordinate[] sectionPts = new Coordinate[len];
        for (int i = 0; i < len; ++i) {
            int index = (start + i) % (srcPts.length - 1);
            sectionPts[i] = srcPts[index].copy();
        }
        return new OffsetCurveSection(sectionPts, loc, locLast);
    }

    OffsetCurveSection(Coordinate[] pts, double loc, double locLast) {
        this.sectionPts = pts;
        this.location = loc;
        this.locLast = locLast;
    }

    private Coordinate[] getCoordinates() {
        return this.sectionPts;
    }

    private boolean isEndInSameSegment(double nextLoc) {
        int segIndex = (int)this.locLast;
        int nextIndex = (int)nextLoc;
        return segIndex == nextIndex;
    }

    @Override
    public int compareTo(OffsetCurveSection section) {
        return Double.compare(this.location, section.location);
    }
}

