/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.overlay.validate;

import com.databricks.internal.jts.algorithm.PointLocator;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateSequence;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LineSegment;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.MultiLineString;
import com.databricks.internal.jts.operation.overlay.validate.PolygonalLineworkExtracter;
import java.util.List;

public class FuzzyPointLocator {
    private Geometry g;
    private double boundaryDistanceTolerance;
    private MultiLineString linework;
    private PointLocator ptLocator = new PointLocator();
    private LineSegment seg = new LineSegment();

    public FuzzyPointLocator(Geometry g2, double boundaryDistanceTolerance) {
        this.g = g2;
        this.boundaryDistanceTolerance = boundaryDistanceTolerance;
        this.linework = this.extractLinework(g2);
    }

    public int getLocation(Coordinate pt) {
        if (this.isWithinToleranceOfBoundary(pt)) {
            return 1;
        }
        return this.ptLocator.locate(pt, this.g);
    }

    private MultiLineString extractLinework(Geometry g2) {
        PolygonalLineworkExtracter extracter = new PolygonalLineworkExtracter();
        g2.apply(extracter);
        List linework = extracter.getLinework();
        LineString[] lines = GeometryFactory.toLineStringArray(linework);
        return g2.getFactory().createMultiLineString(lines);
    }

    private boolean isWithinToleranceOfBoundary(Coordinate pt) {
        for (int i = 0; i < this.linework.getNumGeometries(); ++i) {
            LineString line = (LineString)this.linework.getGeometryN(i);
            CoordinateSequence seq = line.getCoordinateSequence();
            for (int j = 0; j < seq.size() - 1; ++j) {
                seq.getCoordinate(j, this.seg.p0);
                seq.getCoordinate(j + 1, this.seg.p1);
                double dist = this.seg.distance(pt);
                if (!(dist <= this.boundaryDistanceTolerance)) continue;
                return true;
            }
        }
        return false;
    }
}

