/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.relateng;

import com.databricks.internal.jts.algorithm.RobustLineIntersector;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.noding.SegmentIntersector;
import com.databricks.internal.jts.noding.SegmentString;
import com.databricks.internal.jts.operation.relateng.NodeSection;
import com.databricks.internal.jts.operation.relateng.RelateSegmentString;
import com.databricks.internal.jts.operation.relateng.TopologyComputer;

class EdgeSegmentIntersector
implements SegmentIntersector {
    private RobustLineIntersector li = new RobustLineIntersector();
    private TopologyComputer topoComputer;

    public EdgeSegmentIntersector(TopologyComputer topoBuilder) {
        this.topoComputer = topoBuilder;
    }

    @Override
    public boolean isDone() {
        return this.topoComputer.isResultKnown();
    }

    @Override
    public void processIntersections(SegmentString ss0, int segIndex0, SegmentString ss1, int segIndex1) {
        if (ss0 == ss1 && segIndex0 == segIndex1) {
            return;
        }
        RelateSegmentString rss0 = (RelateSegmentString)ss0;
        RelateSegmentString rss1 = (RelateSegmentString)ss1;
        if (rss0.isA()) {
            this.addIntersections(rss0, segIndex0, rss1, segIndex1);
        } else {
            this.addIntersections(rss1, segIndex1, rss0, segIndex0);
        }
    }

    private void addIntersections(RelateSegmentString ssA, int segIndexA, RelateSegmentString ssB, int segIndexB) {
        Coordinate a0 = ssA.getCoordinate(segIndexA);
        Coordinate a1 = ssA.getCoordinate(segIndexA + 1);
        Coordinate b0 = ssB.getCoordinate(segIndexB);
        Coordinate b1 = ssB.getCoordinate(segIndexB + 1);
        this.li.computeIntersection(a0, a1, b0, b1);
        if (!this.li.hasIntersection()) {
            return;
        }
        for (int i = 0; i < this.li.getIntersectionNum(); ++i) {
            Coordinate intPt = this.li.getIntersection(i);
            if (!this.li.isProper() && (!ssA.isContainingSegment(segIndexA, intPt) || !ssB.isContainingSegment(segIndexB, intPt))) continue;
            NodeSection nsa = ssA.createNodeSection(segIndexA, intPt);
            NodeSection nsb = ssB.createNodeSection(segIndexB, intPt);
            this.topoComputer.addIntersection(nsa, nsb);
        }
    }
}

