/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.triangulate;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.util.LinearComponentExtracter;
import com.databricks.internal.jts.triangulate.ConformingDelaunayTriangulator;
import com.databricks.internal.jts.triangulate.ConstraintVertex;
import com.databricks.internal.jts.triangulate.DelaunayTriangulationBuilder;
import com.databricks.internal.jts.triangulate.Segment;
import com.databricks.internal.jts.triangulate.quadedge.QuadEdgeSubdivision;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ConformingDelaunayTriangulationBuilder {
    private Collection siteCoords;
    private Geometry constraintLines;
    private double tolerance = 0.0;
    private QuadEdgeSubdivision subdiv = null;
    private Map constraintVertexMap = new TreeMap();

    public void setSites(Geometry geom) {
        this.siteCoords = DelaunayTriangulationBuilder.extractUniqueCoordinates(geom);
    }

    public void setConstraints(Geometry constraintLines) {
        this.constraintLines = constraintLines;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    private void create() {
        if (this.subdiv != null) {
            return;
        }
        Envelope siteEnv = DelaunayTriangulationBuilder.envelope(this.siteCoords);
        List segments = new ArrayList();
        if (this.constraintLines != null) {
            siteEnv.expandToInclude(this.constraintLines.getEnvelopeInternal());
            this.createVertices(this.constraintLines);
            segments = ConformingDelaunayTriangulationBuilder.createConstraintSegments(this.constraintLines);
        }
        List sites = this.createSiteVertices(this.siteCoords);
        ConformingDelaunayTriangulator cdt = new ConformingDelaunayTriangulator(sites, this.tolerance);
        cdt.setConstraints(segments, new ArrayList(this.constraintVertexMap.values()));
        cdt.formInitialDelaunay();
        cdt.enforceConstraints();
        this.subdiv = cdt.getSubdivision();
    }

    private List createSiteVertices(Collection coords) {
        ArrayList<ConstraintVertex> verts = new ArrayList<ConstraintVertex>();
        for (Coordinate coord : coords) {
            if (this.constraintVertexMap.containsKey(coord)) continue;
            verts.add(new ConstraintVertex(coord));
        }
        return verts;
    }

    private void createVertices(Geometry geom) {
        Coordinate[] coords = geom.getCoordinates();
        for (int i = 0; i < coords.length; ++i) {
            ConstraintVertex v = new ConstraintVertex(coords[i]);
            this.constraintVertexMap.put(coords[i], v);
        }
    }

    private static List createConstraintSegments(Geometry geom) {
        List lines = LinearComponentExtracter.getLines(geom);
        ArrayList constraintSegs = new ArrayList();
        for (LineString line : lines) {
            ConformingDelaunayTriangulationBuilder.createConstraintSegments(line, constraintSegs);
        }
        return constraintSegs;
    }

    private static void createConstraintSegments(LineString line, List constraintSegs) {
        Coordinate[] coords = line.getCoordinates();
        for (int i = 1; i < coords.length; ++i) {
            constraintSegs.add(new Segment(coords[i - 1], coords[i]));
        }
    }

    public QuadEdgeSubdivision getSubdivision() {
        this.create();
        return this.subdiv;
    }

    public Geometry getEdges(GeometryFactory geomFact) {
        this.create();
        return this.subdiv.getEdges(geomFact);
    }

    public Geometry getTriangles(GeometryFactory geomFact) {
        this.create();
        return this.subdiv.getTriangles(geomFact);
    }
}

