/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.retry;

import com.databricks.internal.sdk.core.DatabricksError;
import com.databricks.internal.sdk.core.retry.RetryStrategy;
import com.databricks.internal.sdk.core.retry.RetryUtils;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NonIdempotentRequestRetryStrategy
implements RetryStrategy {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass().getName());
    private static final List<Class<? extends Throwable>> RETRIABLE_CLASSES = Arrays.asList(ConnectException.class, UnknownHostException.class, NoRouteToHostException.class, PortUnreachableException.class);
    private static final Set<Integer> RETRIABLE_HTTP_CODES = new HashSet<Integer>(Arrays.asList(429, 501, 503));

    @Override
    public boolean isRetriable(DatabricksError databricksError) {
        if (RetryUtils.isCausedByTransientError(databricksError)) {
            return true;
        }
        if (this.isClientSideException(databricksError)) {
            return true;
        }
        return this.isRetriableHttpErrorCode(databricksError);
    }

    private boolean isRetriableHttpErrorCode(DatabricksError databricksError) {
        return RETRIABLE_HTTP_CODES.contains(databricksError.getStatusCode());
    }

    private boolean isClientSideException(DatabricksError error) {
        for (Class<? extends Throwable> clazz : RETRIABLE_CLASSES) {
            if (!NonIdempotentRequestRetryStrategy.isCausedBy(error.getCause(), clazz)) continue;
            this.LOGGER.debug("Attempting retry because cause or nested cause extends {}", (Object)clazz.getName());
            return true;
        }
        return false;
    }

    private static boolean isCausedBy(Throwable throwable, Class<? extends Throwable> clazz) {
        if (throwable == null) {
            return false;
        }
        if (clazz.isInstance(throwable)) {
            return true;
        }
        return NonIdempotentRequestRetryStrategy.isCausedBy(throwable.getCause(), clazz);
    }
}

