/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.utils;

import com.databricks.internal.fasterxml.jackson.core.JsonGenerator;
import com.databricks.internal.fasterxml.jackson.core.JsonParser;
import com.databricks.internal.fasterxml.jackson.databind.DeserializationContext;
import com.databricks.internal.fasterxml.jackson.databind.JsonDeserializer;
import com.databricks.internal.fasterxml.jackson.databind.JsonSerializer;
import com.databricks.internal.fasterxml.jackson.databind.SerializerProvider;
import com.databricks.internal.fasterxml.jackson.databind.module.SimpleModule;
import com.databricks.internal.google.protobuf.Duration;
import com.databricks.internal.google.protobuf.FieldMask;
import com.databricks.internal.google.protobuf.Timestamp;
import com.databricks.internal.google.protobuf.util.Durations;
import com.databricks.internal.google.protobuf.util.Timestamps;
import java.io.IOException;

public class ProtobufModule
extends SimpleModule {
    public ProtobufModule() {
        super("ProtobufModule");
        this.addSerializer(FieldMask.class, new FieldMaskSerializer());
        this.addDeserializer(FieldMask.class, new FieldMaskDeserializer());
        this.addSerializer(Duration.class, new DurationSerializer());
        this.addDeserializer(Duration.class, new DurationDeserializer());
        this.addSerializer(Timestamp.class, new TimestampSerializer());
        this.addDeserializer(Timestamp.class, new TimestampDeserializer());
    }

    public static class TimestampDeserializer
    extends JsonDeserializer<Timestamp> {
        @Override
        public Timestamp deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String timestampString = p.getValueAsString();
            if (timestampString == null || timestampString.trim().isEmpty()) {
                return Timestamp.getDefaultInstance();
            }
            try {
                return Timestamps.parse(timestampString.trim());
            }
            catch (Exception e) {
                throw new IOException("Invalid timestamp format: " + timestampString, e);
            }
        }
    }

    public static class TimestampSerializer
    extends JsonSerializer<Timestamp> {
        @Override
        public void serialize(Timestamp timestamp, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Timestamps.toString(timestamp));
        }
    }

    public static class DurationDeserializer
    extends JsonDeserializer<Duration> {
        @Override
        public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String durationString = p.getValueAsString();
            if (durationString == null || durationString.trim().isEmpty()) {
                return Duration.getDefaultInstance();
            }
            try {
                return Durations.parse(durationString.trim());
            }
            catch (Exception e) {
                throw new IOException("Invalid duration format: " + durationString, e);
            }
        }
    }

    public static class DurationSerializer
    extends JsonSerializer<Duration> {
        @Override
        public void serialize(Duration duration, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Durations.toString(duration));
        }
    }

    public static class FieldMaskDeserializer
    extends JsonDeserializer<FieldMask> {
        @Override
        public FieldMask deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String[] paths;
            String pathsString = p.getValueAsString();
            if (pathsString == null || pathsString.trim().isEmpty()) {
                return FieldMask.getDefaultInstance();
            }
            FieldMask.Builder builder = FieldMask.newBuilder();
            for (String path : paths = pathsString.split(",")) {
                String trimmedPath = path.trim();
                if (trimmedPath.isEmpty()) continue;
                builder.addPaths(trimmedPath);
            }
            return builder.build();
        }
    }

    public static class FieldMaskSerializer
    extends JsonSerializer<FieldMask> {
        @Override
        public void serialize(FieldMask fieldMask, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(String.join((CharSequence)",", fieldMask.getPathsList()));
        }
    }
}

