/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.cleanrooms;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoom;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomStatusEnum;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomsImpl;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomsService;
import com.databricks.internal.sdk.service.cleanrooms.CreateCleanRoomOutputCatalogRequest;
import com.databricks.internal.sdk.service.cleanrooms.CreateCleanRoomOutputCatalogResponse;
import com.databricks.internal.sdk.service.cleanrooms.CreateCleanRoomRequest;
import com.databricks.internal.sdk.service.cleanrooms.DeleteCleanRoomRequest;
import com.databricks.internal.sdk.service.cleanrooms.GetCleanRoomRequest;
import com.databricks.internal.sdk.service.cleanrooms.ListCleanRoomsRequest;
import com.databricks.internal.sdk.service.cleanrooms.ListCleanRoomsResponse;
import com.databricks.internal.sdk.service.cleanrooms.UpdateCleanRoomRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.sdk.support.Wait;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

@Generated
public class CleanRoomsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CleanRoomsAPI.class);
    private final CleanRoomsService impl;

    public CleanRoomsAPI(ApiClient apiClient) {
        this.impl = new CleanRoomsImpl(apiClient);
    }

    public CleanRoomsAPI(CleanRoomsService mock) {
        this.impl = mock;
    }

    public CleanRoom waitGetCleanRoomActive(String name) throws TimeoutException {
        return this.waitGetCleanRoomActive(name, Duration.ofMinutes(20L), null);
    }

    public CleanRoom waitGetCleanRoomActive(String name, Duration timeout, Consumer<CleanRoom> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<CleanRoomStatusEnum> targetStates = Arrays.asList(CleanRoomStatusEnum.ACTIVE);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            CleanRoom poll = this.get(new GetCleanRoomRequest().setName(name));
            CleanRoomStatusEnum status = poll.getStatus();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            String prefix = String.format("name=%s", name);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public Wait<CleanRoom, CleanRoom> create(CreateCleanRoomRequest request) {
        CleanRoom response = this.impl.create(request);
        return new Wait<CleanRoom, CleanRoom>((timeout, callback) -> this.waitGetCleanRoomActive(response.getName(), timeout, callback), response);
    }

    public CreateCleanRoomOutputCatalogResponse createOutputCatalog(CreateCleanRoomOutputCatalogRequest request) {
        return this.impl.createOutputCatalog(request);
    }

    public void delete(String name) {
        this.delete(new DeleteCleanRoomRequest().setName(name));
    }

    public void delete(DeleteCleanRoomRequest request) {
        this.impl.delete(request);
    }

    public CleanRoom get(String name) {
        return this.get(new GetCleanRoomRequest().setName(name));
    }

    public CleanRoom get(GetCleanRoomRequest request) {
        return this.impl.get(request);
    }

    public Iterable<CleanRoom> list(ListCleanRoomsRequest request) {
        return new Paginator(request, this.impl::list, ListCleanRoomsResponse::getCleanRooms, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public CleanRoom update(UpdateCleanRoomRequest request) {
        return this.impl.update(request);
    }

    public CleanRoomsService impl() {
        return this.impl;
    }
}

