/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.ml;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.service.ml.CreateForecastingExperimentRequest;
import com.databricks.internal.sdk.service.ml.CreateForecastingExperimentResponse;
import com.databricks.internal.sdk.service.ml.ForecastingExperiment;
import com.databricks.internal.sdk.service.ml.ForecastingExperimentState;
import com.databricks.internal.sdk.service.ml.ForecastingImpl;
import com.databricks.internal.sdk.service.ml.ForecastingService;
import com.databricks.internal.sdk.service.ml.GetForecastingExperimentRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Wait;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

@Generated
public class ForecastingAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ForecastingAPI.class);
    private final ForecastingService impl;

    public ForecastingAPI(ApiClient apiClient) {
        this.impl = new ForecastingImpl(apiClient);
    }

    public ForecastingAPI(ForecastingService mock) {
        this.impl = mock;
    }

    public ForecastingExperiment waitGetExperimentForecastingSucceeded(String experimentId) throws TimeoutException {
        return this.waitGetExperimentForecastingSucceeded(experimentId, Duration.ofMinutes(120L), null);
    }

    public ForecastingExperiment waitGetExperimentForecastingSucceeded(String experimentId, Duration timeout, Consumer<ForecastingExperiment> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<ForecastingExperimentState> targetStates = Arrays.asList(ForecastingExperimentState.SUCCEEDED);
        List<ForecastingExperimentState> failureStates = Arrays.asList(ForecastingExperimentState.FAILED, ForecastingExperimentState.CANCELLED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            ForecastingExperiment poll = this.getExperiment(new GetForecastingExperimentRequest().setExperimentId(experimentId));
            ForecastingExperimentState status = poll.getState();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach SUCCEEDED, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("experimentId=%s", experimentId);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public Wait<ForecastingExperiment, CreateForecastingExperimentResponse> createExperiment(CreateForecastingExperimentRequest request) {
        CreateForecastingExperimentResponse response = this.impl.createExperiment(request);
        return new Wait<ForecastingExperiment, CreateForecastingExperimentResponse>((timeout, callback) -> this.waitGetExperimentForecastingSucceeded(response.getExperimentId(), timeout, callback), response);
    }

    public ForecastingExperiment getExperiment(String experimentId) {
        return this.getExperiment(new GetForecastingExperimentRequest().setExperimentId(experimentId));
    }

    public ForecastingExperiment getExperiment(GetForecastingExperimentRequest request) {
        return this.impl.getExperiment(request);
    }

    public ForecastingService impl() {
        return this.impl;
    }
}

