/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.jdbc.api.impl.IExecutionResult;
import com.databricks.jdbc.api.impl.JsonChunkProvider;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.model.core.ResultData;
import com.databricks.jdbc.model.core.ResultManifest;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class InlineJsonResult
implements IExecutionResult {
    private long currentRow;
    private List<List<Object>> data;
    private JsonChunkProvider chunkProvider;
    private boolean isClosed;

    public InlineJsonResult(ResultManifest resultManifest, ResultData resultData, StatementId statementId, IDatabricksSession session) throws DatabricksSQLException {
        this.chunkProvider = new JsonChunkProvider(resultManifest, resultData, statementId, session);
        this.data = this.chunkProvider.getAllData();
        this.currentRow = -1L;
        this.isClosed = false;
    }

    public InlineJsonResult(Object[][] rows) {
        this(Arrays.stream(rows).map(row -> Arrays.stream(row).collect(Collectors.toList())).collect(Collectors.toList()));
    }

    public InlineJsonResult(List<List<Object>> rows) {
        this.data = rows.stream().map(ArrayList::new).collect(Collectors.toList());
        this.currentRow = -1L;
        this.isClosed = false;
    }

    @Override
    public Object getObject(int columnIndex) throws DatabricksSQLException {
        if (this.isClosed()) {
            throw new DatabricksSQLException("Result is already closed", DatabricksDriverErrorCode.STATEMENT_CLOSED);
        }
        if (this.currentRow == -1L) {
            throw new DatabricksSQLException("Cursor is before first row", DatabricksDriverErrorCode.INVALID_STATE);
        }
        if (columnIndex < this.data.get((int)this.currentRow).size()) {
            return this.data.get((int)this.currentRow).get(columnIndex);
        }
        throw new DatabricksSQLException("Column index out of bounds " + columnIndex, DatabricksDriverErrorCode.INVALID_STATE);
    }

    @Override
    public long getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        if (this.hasNext()) {
            ++this.currentRow;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return !this.isClosed() && this.currentRow < (long)(this.data.size() - 1);
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.data = null;
        if (this.chunkProvider != null) {
            this.chunkProvider.close();
        }
    }

    @Override
    public long getRowCount() {
        return this.data.size();
    }

    @Override
    public long getChunkCount() {
        return this.chunkProvider.getChunkCount();
    }

    private boolean isClosed() {
        return this.isClosed;
    }
}

