/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.arrow;

import com.databricks.internal.apache.arrow.memory.BufferAllocator;
import com.databricks.internal.apache.arrow.memory.RootAllocator;
import com.databricks.internal.apache.arrow.vector.ValueVector;
import com.databricks.internal.apache.arrow.vector.VectorSchemaRoot;
import com.databricks.internal.apache.arrow.vector.ipc.ArrowStreamReader;
import com.databricks.internal.apache.arrow.vector.util.TransferPair;
import com.databricks.internal.apache.commons.lang3.exception.ExceptionUtils;
import com.databricks.jdbc.api.impl.arrow.ArrowResultChunkIterator;
import com.databricks.jdbc.api.impl.arrow.ArrowResultChunkStateMachine;
import com.databricks.jdbc.api.impl.arrow.ChunkStatus;
import com.databricks.jdbc.common.CompressionCodec;
import com.databricks.jdbc.common.util.DriverUtil;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.core.ExternalLink;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedByInterruptException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public abstract class AbstractArrowResultChunk {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(AbstractArrowResultChunk.class);
    protected static final Integer SECONDS_BUFFER_FOR_EXPIRY = 60;
    protected final long numRows;
    protected final long rowOffset;
    protected final long chunkIndex;
    protected final StatementId statementId;
    protected final BufferAllocator rootAllocator;
    protected final CompletableFuture<Void> chunkReadyFuture;
    protected final ArrowResultChunkStateMachine stateMachine;
    protected List<List<ValueVector>> recordBatchList;
    protected ExternalLink chunkLink;
    protected Instant expiryTime;
    protected String errorMessage;
    protected List<String> arrowMetadata;
    protected int chunkReadyTimeoutSeconds;

    protected AbstractArrowResultChunk(long numRows, long rowOffset, long chunkIndex, StatementId statementId, ChunkStatus initialStatus, ExternalLink chunkLink, Instant expiryTime, int chunkReadyTimeoutSeconds) {
        this.numRows = numRows;
        this.rowOffset = rowOffset;
        this.chunkIndex = chunkIndex;
        this.statementId = statementId;
        this.rootAllocator = new RootAllocator(Integer.MAX_VALUE);
        this.chunkReadyFuture = new CompletableFuture();
        this.chunkLink = chunkLink;
        this.expiryTime = expiryTime;
        this.stateMachine = new ArrowResultChunkStateMachine(initialStatus, chunkIndex, statementId);
        this.chunkReadyTimeoutSeconds = chunkReadyTimeoutSeconds;
    }

    public Long getChunkIndex() {
        return this.chunkIndex;
    }

    public long getStartRowOffset() {
        return this.rowOffset;
    }

    public boolean isChunkLinkInvalid() {
        return this.getStatus() == ChunkStatus.PENDING || !DriverUtil.isRunningAgainstFake() && this.expiryTime.minusSeconds(SECONDS_BUFFER_FOR_EXPIRY.intValue()).isBefore(Instant.now());
    }

    public boolean releaseChunk() {
        if (this.getStatus() == ChunkStatus.CHUNK_RELEASED) {
            return false;
        }
        if (this.getStatus() == ChunkStatus.PROCESSING_SUCCEEDED) {
            this.logAllocatorStats("BeforeRelease");
            this.purgeArrowData(this.recordBatchList);
            this.rootAllocator.close();
        }
        this.setStatus(ChunkStatus.CHUNK_RELEASED);
        return true;
    }

    public ExternalLink getChunkLink() {
        return this.chunkLink;
    }

    public void setChunkLink(ExternalLink chunk) {
        this.chunkLink = chunk;
        this.expiryTime = Instant.parse(chunk.getExpiration());
        this.setStatus(ChunkStatus.URL_FETCHED);
    }

    public ChunkStatus getStatus() {
        return this.stateMachine.getCurrentStatus();
    }

    protected abstract void downloadData(IDatabricksHttpClient var1, CompressionCodec var2, double var3) throws DatabricksParsingException, IOException;

    protected abstract void handleFailure(Exception var1, ChunkStatus var2) throws DatabricksParsingException;

    protected int getRecordBatchCountInChunk() {
        return this.getStatus() == ChunkStatus.PROCESSING_SUCCEEDED ? this.recordBatchList.size() : 0;
    }

    protected List<List<ValueVector>> getRecordBatchList() {
        return this.recordBatchList;
    }

    protected long getNumRows() {
        return this.numRows;
    }

    protected ValueVector getColumnVector(int recordBatchIndex, int columnIndex) {
        return this.recordBatchList.get(recordBatchIndex).get(columnIndex);
    }

    protected void setStatus(ChunkStatus targetStatus) {
        try {
            this.stateMachine.transition(targetStatus);
        }
        catch (DatabricksParsingException e) {
            LOGGER.warn("Failed to transition to state [{}] from state [{}] for chunk [{}] and statement [{}]. Stack trace: {}", new Object[]{targetStatus, this.getStatus(), this.chunkIndex, this.statementId, ExceptionUtils.getStackTrace(e)});
        }
    }

    protected ArrowResultChunkIterator getChunkIterator() {
        return new ArrowResultChunkIterator(this);
    }

    protected CompletableFuture<Void> getChunkReadyFuture() {
        return this.chunkReadyFuture;
    }

    protected void waitForChunkReady() throws ExecutionException, InterruptedException, TimeoutException {
        try {
            if (this.chunkReadyTimeoutSeconds <= 0) {
                this.chunkReadyFuture.get();
            } else {
                this.chunkReadyFuture.get(this.chunkReadyTimeoutSeconds, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error(e, "Chunk download interrupted for chunk index {} and statement {}", this.chunkIndex, this.statementId);
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    protected void initializeData(InputStream inputStream) throws DatabricksSQLException, IOException {
        LOGGER.debug("Parsing data for chunk index {} and statement {}", this.chunkIndex, this.statementId);
        ArrowData arrowData = this.getRecordBatchList(inputStream, this.rootAllocator, this.statementId, this.chunkIndex);
        this.recordBatchList = arrowData.getValueVectors();
        this.arrowMetadata = arrowData.getMetadata();
        LOGGER.debug("Data parsed for chunk index {} and statement {}. Row count: {}", this.chunkIndex, this.statementId, arrowData.getRowCount());
        this.setStatus(ChunkStatus.PROCESSING_SUCCEEDED);
    }

    protected List<String> getArrowMetadata() {
        return this.arrowMetadata;
    }

    private ArrowData getRecordBatchList(InputStream inputStream, BufferAllocator rootAllocator, StatementId statementId, long chunkIndex) throws IOException {
        ArrayList<List<ValueVector>> recordBatchList = new ArrayList<List<ValueVector>>();
        List<String> metadata = new ArrayList<String>();
        long rowCount = 0L;
        try (ArrowStreamReader arrowStreamReader = new ArrowStreamReader(inputStream, rootAllocator);){
            VectorSchemaRoot vectorSchemaRoot = arrowStreamReader.getVectorSchemaRoot();
            boolean fetchedMetadata = false;
            while (arrowStreamReader.loadNextBatch()) {
                rowCount += (long)vectorSchemaRoot.getRowCount();
                if (!fetchedMetadata) {
                    metadata = this.getMetadataInformationFromSchemaRoot(vectorSchemaRoot);
                    fetchedMetadata = true;
                }
                recordBatchList.add(this.getVectorsFromSchemaRoot(vectorSchemaRoot, rootAllocator));
                vectorSchemaRoot.clear();
            }
        }
        catch (ClosedByInterruptException e) {
            LOGGER.error(e, "Data parsing interrupted for chunk index [{}] and statement [{}]. Error [{}]", chunkIndex, statementId, e.getMessage());
            this.purgeArrowData(recordBatchList);
        }
        catch (IOException e) {
            LOGGER.error("Error while reading arrow data, purging the local list and rethrowing the exception.");
            this.purgeArrowData(recordBatchList);
            throw e;
        }
        return new ArrowData(recordBatchList, metadata, rowCount);
    }

    private List<String> getMetadataInformationFromSchemaRoot(VectorSchemaRoot vectorSchemaRoot) {
        return vectorSchemaRoot.getFieldVectors().stream().map(fieldVector -> fieldVector.getField().getMetadata().get("Spark:DataType:SqlName")).collect(Collectors.toList());
    }

    private List<ValueVector> getVectorsFromSchemaRoot(VectorSchemaRoot vectorSchemaRoot, BufferAllocator rootAllocator) {
        return vectorSchemaRoot.getFieldVectors().stream().map(fieldVector -> {
            TransferPair transferPair = fieldVector.getTransferPair(rootAllocator);
            transferPair.transfer();
            return transferPair.getTo();
        }).collect(Collectors.toList());
    }

    private void logAllocatorStats(String event) {
        long allocatedMemory = this.rootAllocator.getAllocatedMemory();
        long peakMemory = this.rootAllocator.getPeakMemoryAllocation();
        long headRoom = this.rootAllocator.getHeadroom();
        long initReservation = this.rootAllocator.getInitReservation();
        LOGGER.debug("Chunk allocator stats Log - Event: {}, Chunk Index: {}, Allocated Memory: {}, Peak Memory: {}, Headroom: {}, Init Reservation: {}", event, this.chunkIndex, allocatedMemory, peakMemory, headRoom, initReservation);
    }

    private void purgeArrowData(List<List<ValueVector>> recordBatchList) {
        recordBatchList.forEach(vectors -> vectors.forEach(ValueVector::close));
        recordBatchList.clear();
    }

    static final class ArrowData {
        private final List<List<ValueVector>> valueVectors;
        private final List<String> metadata;
        private final long rowCount;

        public ArrowData(List<List<ValueVector>> valueVectors, List<String> metadata, long rowCount) {
            this.valueVectors = valueVectors;
            this.metadata = metadata;
            this.rowCount = rowCount;
        }

        public List<List<ValueVector>> getValueVectors() {
            return this.valueVectors;
        }

        public List<String> getMetadata() {
            return this.metadata;
        }

        public long getRowCount() {
            return this.rowCount;
        }
    }
}

