/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.converters;

import com.databricks.jdbc.api.impl.DatabricksGeography;
import com.databricks.jdbc.api.impl.DatabricksGeometry;
import com.databricks.jdbc.api.impl.converters.BigDecimalConverter;
import com.databricks.jdbc.api.impl.converters.BitConverter;
import com.databricks.jdbc.api.impl.converters.BooleanConverter;
import com.databricks.jdbc.api.impl.converters.ByteArrayConverter;
import com.databricks.jdbc.api.impl.converters.ByteConverter;
import com.databricks.jdbc.api.impl.converters.DateConverter;
import com.databricks.jdbc.api.impl.converters.DoubleConverter;
import com.databricks.jdbc.api.impl.converters.FloatConverter;
import com.databricks.jdbc.api.impl.converters.GeospatialConverter;
import com.databricks.jdbc.api.impl.converters.IntConverter;
import com.databricks.jdbc.api.impl.converters.LongConverter;
import com.databricks.jdbc.api.impl.converters.ObjectConverter;
import com.databricks.jdbc.api.impl.converters.ShortConverter;
import com.databricks.jdbc.api.impl.converters.StringConverter;
import com.databricks.jdbc.api.impl.converters.TimestampConverter;
import com.databricks.jdbc.exception.DatabricksSQLException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Date;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConverterHelper {
    private static final Map<Integer, ObjectConverter> CONVERTER_CACHE = new HashMap<Integer, ObjectConverter>();
    private static final Map<Integer, List<Integer>> SUPPORTED_CONVERSIONS = new HashMap<Integer, List<Integer>>();
    private static final GeospatialConverter GEOSPATIAL_CONVERTER = new GeospatialConverter();

    public static Object convertSqlTypeToJavaType(int columnSqlType, Object object) throws DatabricksSQLException {
        switch (columnSqlType) {
            case -6: {
                return ConverterHelper.convertSqlTypeToSpecificJavaType(Byte.class, -6, object);
            }
            case 5: {
                return ConverterHelper.convertSqlTypeToSpecificJavaType(Short.class, 5, object);
            }
            case 4: {
                return ConverterHelper.convertSqlTypeToSpecificJavaType(Integer.class, 4, object);
            }
            case -5: {
                return ConverterHelper.convertSqlTypeToSpecificJavaType(Long.class, -5, object);
            }
            case 6: {
                return ConverterHelper.convertSqlTypeToSpecificJavaType(Float.class, 6, object);
            }
            case 8: {
                return ConverterHelper.convertSqlTypeToSpecificJavaType(Double.class, 8, object);
            }
            case 3: {
                return ConverterHelper.convertSqlTypeToSpecificJavaType(BigDecimal.class, 3, object);
            }
            case 16: {
                return ConverterHelper.convertSqlTypeToSpecificJavaType(Boolean.class, 16, object);
            }
            case 91: {
                return ConverterHelper.convertSqlTypeToSpecificJavaType(java.util.Date.class, 91, object);
            }
            case 92: {
                return ConverterHelper.convertSqlTypeToSpecificJavaType(Time.class, 92, object);
            }
            case 93: {
                return ConverterHelper.convertSqlTypeToSpecificJavaType(Timestamp.class, 93, object);
            }
            case -2: {
                return ConverterHelper.convertSqlTypeToSpecificJavaType(byte[].class, -2, object);
            }
            case -7: {
                return ConverterHelper.convertSqlTypeToSpecificJavaType(Boolean.class, -7, object);
            }
        }
        return ConverterHelper.convertSqlTypeToSpecificJavaType(String.class, 12, object);
    }

    public static Object convertSqlTypeToSpecificJavaType(Class<?> javaType, int columnSqlType, Object obj) throws DatabricksSQLException {
        ObjectConverter converter = ConverterHelper.getConverterForSqlType(columnSqlType);
        if (javaType == String.class) {
            return converter.toString(obj);
        }
        if (javaType == BigDecimal.class) {
            return converter.toBigDecimal(obj);
        }
        if (javaType == Boolean.class || javaType == Boolean.TYPE) {
            return converter.toBoolean(obj);
        }
        if (javaType == Integer.class || javaType == Integer.TYPE) {
            return converter.toInt(obj);
        }
        if (javaType == Long.class || javaType == Long.TYPE) {
            return converter.toLong(obj);
        }
        if (javaType == Float.class || javaType == Float.TYPE) {
            return Float.valueOf(converter.toFloat(obj));
        }
        if (javaType == Double.class || javaType == Double.TYPE) {
            return converter.toDouble(obj);
        }
        if (javaType == LocalDate.class) {
            return converter.toLocalDate(obj);
        }
        if (javaType == BigInteger.class) {
            return converter.toBigInteger(obj);
        }
        if (javaType == java.util.Date.class || javaType == Date.class) {
            return converter.toDate(obj);
        }
        if (javaType == Time.class) {
            return converter.toTime(obj);
        }
        if (javaType == Timestamp.class || javaType == Calendar.class) {
            return converter.toTimestamp(obj);
        }
        if (javaType == Byte.TYPE || javaType == Byte.class) {
            return converter.toByte(obj);
        }
        if (javaType == Short.TYPE || javaType == Short.class) {
            return converter.toShort(obj);
        }
        if (javaType == byte[].class) {
            return converter.toByteArray(obj);
        }
        if (javaType == Character.TYPE || javaType == Character.class) {
            return Character.valueOf(converter.toChar(obj));
        }
        if (javaType == Map.class) {
            return converter.toDatabricksMap(obj);
        }
        if (javaType == Array.class) {
            return converter.toDatabricksArray(obj);
        }
        if (javaType == Struct.class) {
            return converter.toDatabricksStruct(obj);
        }
        if (javaType == DatabricksGeometry.class) {
            return converter.toDatabricksGeometry(obj);
        }
        if (javaType == DatabricksGeography.class) {
            return converter.toDatabricksGeography(obj);
        }
        return converter.toString(obj);
    }

    public static ObjectConverter getConverterForSqlType(int columnSqlType) {
        return CONVERTER_CACHE.getOrDefault(columnSqlType, CONVERTER_CACHE.get(12));
    }

    public static ObjectConverter getConverterForColumnType(int columnSqlType, String columnTypeName) {
        if (columnTypeName != null && (columnTypeName.equals("GEOMETRY") || columnTypeName.equals("GEOGRAPHY"))) {
            return GEOSPATIAL_CONVERTER;
        }
        return ConverterHelper.getConverterForSqlType(columnSqlType);
    }

    public static boolean isConversionSupported(int fromType, int toType) {
        return SUPPORTED_CONVERSIONS.containsKey(fromType) && SUPPORTED_CONVERSIONS.get(fromType).contains(toType);
    }

    static {
        SUPPORTED_CONVERSIONS.put(-6, List.of(-6, 5, 4, -5, 3, 8, 7, 6, 1, 2, 12, -9, -2, -3, -7, -1));
        SUPPORTED_CONVERSIONS.put(5, List.of(5, 4, -5, 3, 8, 7, 12, -1, -2, 2, -3, -9, -6, -7, 1, 6, -2, 2, -1));
        SUPPORTED_CONVERSIONS.put(4, List.of(4, -5, 3, 8, 7, -9, 5, 1, -1, -3, -6, 12, -2, -7, 6, 2));
        SUPPORTED_CONVERSIONS.put(-5, List.of(-5, 3, 8, 7, -9, -2, 6, 12, -6, 2, -1, 4, 1, -3, 5, -7));
        SUPPORTED_CONVERSIONS.put(6, List.of(8, 3, 7, 6, -6, -2, 12, -7, 2, -9, 1, -1, 4, 5, -3, -5));
        SUPPORTED_CONVERSIONS.put(7, List.of(7, 8, 3, 12, -9, -3, 2, 5, -2, 4, 1, -5, -6, -7, -1, 6));
        SUPPORTED_CONVERSIONS.put(8, List.of(8, 3, 7, 6, -6, -2, 12, -7, 2, -9, 1, -1, 4, 5, -3, -5));
        SUPPORTED_CONVERSIONS.put(3, List.of(3, 2, 8, 7, -6, 12, -9, 5, 4, -5, 1, 6));
        SUPPORTED_CONVERSIONS.put(2, List.of(2, 3, 8, 7, 1, -9, -5, 6, 12, 5, -6, 4));
        SUPPORTED_CONVERSIONS.put(16, List.of(16, -7, 4, 12, 7, 3, -2, -1, -3, 4, 6, 5, 2, -5, -9, 8, 1, -6, -4));
        SUPPORTED_CONVERSIONS.put(-7, List.of(-7, 4, 12, -2, 3, 8, 1, 2, -6, 7, -4, -5, 6, 5, -9, -3, -1));
        SUPPORTED_CONVERSIONS.put(91, List.of(Integer.valueOf(91), Integer.valueOf(93), Integer.valueOf(12), Integer.valueOf(-3), Integer.valueOf(-9), Integer.valueOf(-2), Integer.valueOf(-1), Integer.valueOf(1)));
        SUPPORTED_CONVERSIONS.put(92, List.of(Integer.valueOf(92), Integer.valueOf(93), Integer.valueOf(12), Integer.valueOf(-3), Integer.valueOf(-1), Integer.valueOf(1), Integer.valueOf(-9), Integer.valueOf(-2)));
        SUPPORTED_CONVERSIONS.put(93, List.of(Integer.valueOf(93), Integer.valueOf(91), Integer.valueOf(92), Integer.valueOf(12), Integer.valueOf(-2), Integer.valueOf(-9), Integer.valueOf(1), Integer.valueOf(-3), Integer.valueOf(-1)));
        SUPPORTED_CONVERSIONS.put(-2, List.of(Integer.valueOf(-2), Integer.valueOf(-3), Integer.valueOf(-4), Integer.valueOf(12), Integer.valueOf(-1), Integer.valueOf(-9), Integer.valueOf(1)));
        SUPPORTED_CONVERSIONS.put(-3, List.of(Integer.valueOf(-3), Integer.valueOf(-4), Integer.valueOf(1), Integer.valueOf(-1), Integer.valueOf(-9), Integer.valueOf(-2), Integer.valueOf(12)));
        SUPPORTED_CONVERSIONS.put(-4, List.of(Integer.valueOf(-4), Integer.valueOf(-2), Integer.valueOf(-3), Integer.valueOf(12), Integer.valueOf(-9), Integer.valueOf(1), Integer.valueOf(-1)));
        SUPPORTED_CONVERSIONS.put(1, List.of(1, 12, -1, 93, 6, -9, -6, -2, -3, 91, -4, 4, 5, 3, 7, 8, -5, 2, -7, 92));
        SUPPORTED_CONVERSIONS.put(12, List.of(12, 1, -1, -9, 93, 3, -7, -2, 5, -5, 6, 92, 4, -4, 91, -3, 2, 7, -6, 8));
        SUPPORTED_CONVERSIONS.put(-1, List.of(-1, 12, -9, 2, 4, -5, 3, 92, 5, 91, -7, -6, 1, 8, 6, 7, 93));
        SUPPORTED_CONVERSIONS.put(-9, List.of(-9, 12, 93, 5, -2, -7, 4, -3, -1, 91, 3, 1, 6, 8, -6, 7, 2, -5, 92, -4));
        SUPPORTED_CONVERSIONS.put(1111, List.of(Integer.valueOf(1111)));
        SUPPORTED_CONVERSIONS.put(2002, List.of(Integer.valueOf(2002), Integer.valueOf(12)));
        SUPPORTED_CONVERSIONS.put(2003, List.of(Integer.valueOf(2003), Integer.valueOf(12)));
        CONVERTER_CACHE.put(-6, new ByteConverter());
        CONVERTER_CACHE.put(5, new ShortConverter());
        CONVERTER_CACHE.put(4, new IntConverter());
        CONVERTER_CACHE.put(-5, new LongConverter());
        CONVERTER_CACHE.put(6, new FloatConverter());
        CONVERTER_CACHE.put(8, new DoubleConverter());
        CONVERTER_CACHE.put(3, new BigDecimalConverter());
        CONVERTER_CACHE.put(16, new BooleanConverter());
        CONVERTER_CACHE.put(91, new DateConverter());
        CONVERTER_CACHE.put(92, new TimestampConverter());
        CONVERTER_CACHE.put(93, new TimestampConverter());
        CONVERTER_CACHE.put(-2, new ByteArrayConverter());
        CONVERTER_CACHE.put(-7, new BitConverter());
        CONVERTER_CACHE.put(12, new StringConverter());
        CONVERTER_CACHE.put(1, new StringConverter());
    }
}

