/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.converters;

import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.io.Ordinate;
import com.databricks.internal.jts.io.ParseException;
import com.databricks.internal.jts.io.WKBReader;
import com.databricks.internal.jts.io.WKTReader;
import com.databricks.internal.jts.io.WKTWriter;
import com.databricks.jdbc.api.impl.converters.JTSOGCWKBWriter;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;

public class WKTConverter {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(WKTConverter.class);

    public static byte[] toWKB(String wkt) throws DatabricksValidationException {
        if (wkt == null || wkt.trim().isEmpty()) {
            throw new DatabricksValidationException("WKT string cannot be null or empty");
        }
        try {
            int ogcDimension = WKTConverter.ogcDimensionFromWkt(wkt);
            EnumSet<Ordinate> ordinates = WKTConverter.determineOrdinates(ogcDimension);
            WKTReader reader = new WKTReader();
            Geometry geometry = reader.read(wkt);
            JTSOGCWKBWriter writer = new JTSOGCWKBWriter(ordinates, ByteOrder.LITTLE_ENDIAN);
            return writer.write(geometry);
        }
        catch (ParseException e) {
            String errorMessage = String.format("Failed to parse WKT: %s. Error: %s", wkt, e.getMessage());
            LOGGER.error(errorMessage, e);
            throw new DatabricksValidationException(errorMessage, e);
        }
    }

    public static String toWKT(byte[] wkb) throws DatabricksValidationException {
        if (wkb == null || wkb.length == 0) {
            throw new DatabricksValidationException("WKB bytes cannot be null or empty");
        }
        try {
            int ogcDimension = WKTConverter.ogcDimensionFromWkb(wkb);
            EnumSet<Ordinate> ordinates = WKTConverter.determineOrdinates(ogcDimension);
            WKBReader reader = new WKBReader();
            Geometry geometry = reader.read(wkb);
            int outputDimension = ordinates.size();
            WKTWriter writer = new WKTWriter(outputDimension);
            writer.setOutputOrdinates(ordinates);
            return writer.write(geometry);
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to parse WKB: %d bytes. Error: %s", wkb.length, e.getMessage());
            LOGGER.error(errorMessage, e);
            throw new DatabricksValidationException(errorMessage, e);
        }
    }

    private static int ogcDimensionFromWkt(String wkt) throws DatabricksValidationException {
        for (int i = 0; i < wkt.length() - 2; ++i) {
            char c = wkt.charAt(i);
            if (c == '(') {
                return 0;
            }
            if (c != ' ') continue;
            char next = Character.toUpperCase(wkt.charAt(i + 1));
            if (next == 'E') {
                return 0;
            }
            if (next == 'M') {
                return 2000;
            }
            if (next != 'Z') continue;
            return i + 2 < wkt.length() && Character.toUpperCase(wkt.charAt(i + 2)) == 'M' ? 3000 : 1000;
        }
        throw new DatabricksValidationException("Invalid WKT input: " + wkt);
    }

    private static int ogcDimensionFromWkb(byte[] wkb) throws DatabricksValidationException {
        if (wkb.length < 5) {
            throw new DatabricksValidationException("Invalid WKB input: insufficient bytes");
        }
        ByteOrder endianness = wkb[0] == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        int type = ByteBuffer.wrap(wkb).order(endianness).getInt(1);
        return type - type % 1000;
    }

    private static EnumSet<Ordinate> determineOrdinates(int ogcDimension) {
        switch (ogcDimension) {
            case 1000: {
                return Ordinate.createXYZ();
            }
            case 2000: {
                return Ordinate.createXYM();
            }
            case 3000: {
                return Ordinate.createXYZM();
            }
        }
        return Ordinate.createXY();
    }

    public static int extractSRIDFromEWKT(String ewkt) {
        int semicolonIndex;
        if (ewkt == null || ewkt.trim().isEmpty()) {
            return 0;
        }
        String trimmed = ewkt.trim();
        if (trimmed.startsWith("SRID=") && (semicolonIndex = trimmed.indexOf(59)) > 0) {
            try {
                String sridStr = trimmed.substring(5, semicolonIndex);
                return Integer.parseInt(sridStr);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Invalid SRID format in EWKT: {}", ewkt);
                return 0;
            }
        }
        return 0;
    }

    public static String removeSRIDFromEWKT(String ewkt) {
        int semicolonIndex;
        if (ewkt == null || ewkt.trim().isEmpty()) {
            return ewkt;
        }
        String trimmed = ewkt.trim();
        if (trimmed.startsWith("SRID=") && (semicolonIndex = trimmed.indexOf(59)) > 0) {
            return trimmed.substring(semicolonIndex + 1);
        }
        return trimmed;
    }
}

