/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.util.concurrent.TimeUnit;

public class SeaCircuitBreakerManager {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(SeaCircuitBreakerManager.class);
    public static final int HTTP_TOO_MANY_REQUESTS = 429;
    private static final long CIRCUIT_BREAK_DURATION_MS = 86400000L;
    private static volatile long last429FailureTimestamp = -1L;

    private SeaCircuitBreakerManager() {
    }

    public static void record429Failure() {
        long currentTime;
        last429FailureTimestamp = currentTime = System.currentTimeMillis();
        LOGGER.warn("SEA circuit breaker OPENED due to 429 rate limit failure. Will use Thrift client for the next 24 hours. Timestamp: {}", currentTime);
    }

    public static boolean isCircuitOpen() {
        boolean isOpen;
        long lastFailure = last429FailureTimestamp;
        if (lastFailure == -1L) {
            return false;
        }
        long elapsed = System.currentTimeMillis() - lastFailure;
        boolean bl = isOpen = elapsed < 86400000L;
        if (!isOpen) {
            LOGGER.trace("SEA circuit breaker CLOSED after 24 hours. Will check feature flag again.");
        }
        return isOpen;
    }

    public static long getTimeRemainingMs() {
        long lastFailure = last429FailureTimestamp;
        if (lastFailure == -1L) {
            return 0L;
        }
        long elapsed = System.currentTimeMillis() - lastFailure;
        if (elapsed >= 86400000L) {
            return 0L;
        }
        return 86400000L - elapsed;
    }

    public static String getTimeRemainingFormatted() {
        long remainingMs = SeaCircuitBreakerManager.getTimeRemainingMs();
        if (remainingMs == 0L) {
            return "closed";
        }
        long hours = TimeUnit.MILLISECONDS.toHours(remainingMs);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(remainingMs) % 60L;
        return String.format("%d hours %d minutes", hours, minutes);
    }

    @VisibleForTesting
    public static void reset() {
        last429FailureTimestamp = -1L;
        LOGGER.debug("SEA circuit breaker has been reset (test only)");
    }
}

