/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.log;

import com.databricks.internal.apache.commons.lang3.StringUtils;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.log.Slf4jFormatter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class JulLogger
implements JdbcLogger {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(JulLogger.class);
    private static final String DEFAULT_PACKAGE_PREFIX = "com.databricks.jdbc";
    private static final String DEFAULT_DRIVER_PACKAGE_PREFIX = "com.databricks.client.jdbc";
    public static final String STDOUT = "STDOUT";
    public static final String PARENT_CLASS_PREFIX = JulLogger.getPackagePrefix();
    public static final String DRIVER_CLASS_PREFIX = JulLogger.getDriverPackagePrefix();
    public static final String DATABRICKS_LOG_FILE = "databricks_jdbc.log";
    public static final String JAVA_UTIL_LOGGING_CONFIG_FILE = "java.util.logging.config.file";
    private static final Set<String> logMethods = Set.of("debug", "error", "info", "trace", "warn");
    protected Logger logger;
    protected static volatile boolean isLoggerInitialized = false;

    public JulLogger(String name) {
        this.logger = Logger.getLogger(name);
    }

    @Override
    public void trace(String message) {
        this.log(Level.FINEST, message, null);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.trace(String.format(this.slf4jToJavaFormat(format), arguments));
    }

    @Override
    public void debug(String message) {
        this.log(Level.FINE, message, null);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.debug(String.format(this.slf4jToJavaFormat(format), arguments));
    }

    @Override
    public void info(String message) {
        this.log(Level.INFO, message, null);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.info(String.format(this.slf4jToJavaFormat(format), arguments));
    }

    @Override
    public void warn(String message) {
        this.log(Level.WARNING, message, null);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.warn(String.format(this.slf4jToJavaFormat(format), arguments));
    }

    @Override
    public void error(String message) {
        this.log(Level.SEVERE, message, null);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.error(String.format(this.slf4jToJavaFormat(format), arguments));
    }

    @Override
    public void error(Throwable throwable, String message) {
        this.log(Level.SEVERE, message, throwable);
    }

    @Override
    public void error(Throwable throwable, String format, Object ... arguments) {
        this.error(String.format(this.slf4jToJavaFormat(format), arguments), throwable);
    }

    public static synchronized void initLogger(Level level, String logDir, int logFileSizeBytes, int logFileCount) throws IOException {
        if (!isLoggerInitialized) {
            isLoggerInitialized = true;
            Logger jdbcJulLogger = Logger.getLogger(PARENT_CLASS_PREFIX);
            jdbcJulLogger.setLevel(level);
            jdbcJulLogger.setUseParentHandlers(false);
            Logger jdbcDriverJulLogger = Logger.getLogger(DRIVER_CLASS_PREFIX);
            jdbcDriverJulLogger.setLevel(level);
            jdbcDriverJulLogger.setUseParentHandlers(false);
            String logPattern = JulLogger.getLogPattern(logDir);
            StreamHandler handler = logPattern.equalsIgnoreCase(STDOUT) ? new StreamHandler(System.out, new Slf4jFormatter()){

                @Override
                public void publish(LogRecord record) {
                    super.publish(record);
                    this.flush();
                }
            } : new FileHandler(logPattern, logFileSizeBytes, logFileCount, true);
            handler.setLevel(level);
            handler.setFormatter(new Slf4jFormatter());
            jdbcJulLogger.addHandler(handler);
            jdbcDriverJulLogger.addHandler(handler);
        }
    }

    private void log(Level level, String message, Throwable throwable) {
        String[] callerClassMethod = JulLogger.getCaller();
        if (throwable == null) {
            this.logger.logp(level, callerClassMethod[0], callerClassMethod[1], message);
        } else {
            this.logger.logp(level, callerClassMethod[0], callerClassMethod[1], message, throwable);
        }
    }

    /*
     * Exception decompiling
     */
    protected static String[] getCaller() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static String getLogPattern(String logDir) {
        if (logDir.equalsIgnoreCase(STDOUT)) {
            return STDOUT;
        }
        Path dirPath = Paths.get(logDir, new String[0]);
        if (Files.notExists(dirPath, new LinkOption[0])) {
            try {
                LOGGER.info("Creating log directory for JUL logging: " + String.valueOf(dirPath));
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.info("Error creating log directory " + String.valueOf(dirPath) + " for JUL logging." + e.getMessage());
                return STDOUT;
            }
        }
        return dirPath.resolve(DATABRICKS_LOG_FILE).toString();
    }

    private static String getPackagePrefix() {
        int defaultPrefixIndex;
        String prefix = System.getenv("JDBC_PACKAGE_PREFIX");
        if (prefix != null && !prefix.isEmpty()) {
            return prefix;
        }
        String actualPackageName = JulLogger.class.getPackage().getName();
        if (actualPackageName.contains(DEFAULT_PACKAGE_PREFIX) && (defaultPrefixIndex = actualPackageName.indexOf(DEFAULT_PACKAGE_PREFIX)) > 0) {
            return actualPackageName.substring(0, defaultPrefixIndex + DEFAULT_PACKAGE_PREFIX.length());
        }
        return DEFAULT_PACKAGE_PREFIX;
    }

    private static String getDriverPackagePrefix() {
        String prefix = System.getenv("JDBC_DRIVER_PACKAGE_PREFIX");
        if (StringUtils.isNotEmpty(prefix)) {
            return prefix;
        }
        String mainPackagePrefix = JulLogger.getPackagePrefix();
        if (!mainPackagePrefix.equals(DEFAULT_PACKAGE_PREFIX) && mainPackagePrefix.contains(DEFAULT_PACKAGE_PREFIX)) {
            String shadingPrefix = mainPackagePrefix.substring(0, mainPackagePrefix.indexOf(DEFAULT_PACKAGE_PREFIX));
            return shadingPrefix + DEFAULT_DRIVER_PACKAGE_PREFIX;
        }
        return DEFAULT_DRIVER_PACKAGE_PREFIX;
    }

    private String slf4jToJavaFormat(String format) {
        if (format == null) {
            return null;
        }
        return format.replace("{}", "%s");
    }
}

