/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.telemetry;

import com.databricks.internal.fasterxml.jackson.annotation.JsonInclude;
import com.databricks.internal.fasterxml.jackson.core.JsonProcessingException;
import com.databricks.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.TelemetryFrontendLog;
import com.databricks.jdbc.model.telemetry.TelemetryRequest;
import com.databricks.jdbc.telemetry.ITelemetryPushClient;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class TelemetryPushTask
implements Runnable {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(TelemetryPushTask.class);
    private final List<TelemetryFrontendLog> queueToBePushed;
    private final ITelemetryPushClient telemetryPushClient;
    private final ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    TelemetryPushTask(List<TelemetryFrontendLog> eventsQueue, ITelemetryPushClient telemetryPushClient) {
        this.queueToBePushed = eventsQueue;
        this.telemetryPushClient = telemetryPushClient;
    }

    @Override
    public void run() {
        LOGGER.trace("Pushing Telemetry logs of size {}", this.queueToBePushed.size());
        TelemetryRequest request = new TelemetryRequest();
        if (this.queueToBePushed.isEmpty()) {
            return;
        }
        try {
            request.setUploadTime(System.currentTimeMillis()).setProtoLogs(this.queueToBePushed.stream().map(event -> {
                try {
                    return this.objectMapper.writeValueAsString(event);
                }
                catch (JsonProcessingException e) {
                    LOGGER.trace("Failed to serialize Telemetry event {} with error: {}", event, e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList()));
            this.telemetryPushClient.pushEvent(request);
        }
        catch (Exception e) {
            LOGGER.trace("Failed to push telemetry logs because of the error {}", e);
        }
    }
}

